*********************************************************************
* Project: The Demand for Government Debt    *
* Description:                                                      *
* This script processes high-frequency monetary policy surprise     *
* data for the US, Euro area, Japan, and UK, and builds a clean     *
* quarterly panel of policy shocks. It also calculates returns on   *
* broad nominal exchange rate indexes for major currencies.         *                                      
*********************************************************************
clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/


// Format MP shocks from the raw file

// US update is more recent and comes from a separate file now. 

// US
preserve
import excel using "$path/raw_data/responses_v15b_w3090_MPDPCsum.xlsx", sheet("US") firstrow clear

keep date Datetime_gmt Country response_qtOIS3m	response_qtGvtFut2y	response_qtGvtFut10y
format date %td

// To keep the start date the same as the previous version: 
keep if date>=td(09dec2003)

rename response_qtOIS3m Ch3m
rename response_qtGvtFut2y Ch2y
rename response_qtGvtFut10y Ch10y

replace Ch3m=0 if missing(Ch3m)
replace Ch2y=0 if missing(Ch2y)
replace Ch10y=0 if missing(Ch10y)

gen Ch2yMinus3m = Ch2y - Ch3m
gen Ch10yMinus2y = Ch10y - Ch2y
gen Ch10yMinus3m=Ch10y - Ch3m

save "$path/generated_data/MP_upd_US.dta", replace

restore

// EU
preserve
import excel using "$path/raw_data/responses_v15b_w3090_MPDPCsum.xlsx", sheet("EU") firstrow clear

keep date Datetime_gmt Country response_qtOIS3m	response_qtDEschatzFut	response_qtDEbundFut
format date %td

// To keep the start date the same as the previous version: 
keep if date>=td(04mar1999)

rename response_qtOIS3m Ch3m
rename response_qtDEschatzFut Ch2y
rename response_qtDEbundFut Ch10y

replace Ch3m=0 if missing(Ch3m)
replace Ch2y=0 if missing(Ch2y)
replace Ch10y=0 if missing(Ch10y)

gen Ch2yMinus3m = Ch2y - Ch3m
gen Ch10yMinus2y = Ch10y - Ch2y
gen Ch10yMinus3m=Ch10y-Ch3m

save "$path/generated_data/MP_upd_EU.dta", replace

restore


// JP
preserve
import excel using "$path/raw_data/responses_v15b_w3090_MPDPCsum.xlsx", sheet("JP") firstrow clear

keep date Datetime_gmt Country response_qtGvtFut3m	response_JP2YZ	response_qtGvtFut10y

format date %td

// To keep the start date the same as the previous version: 
keep if date>=td(19jan1999)

rename response_qtGvtFut3m Ch3m
rename response_JP2YZ Ch2y
rename response_qtGvtFut10y Ch10y

replace Ch3m=0 if missing(Ch3m)
replace Ch2y=0 if missing(Ch2y)
replace Ch10y=0 if missing(Ch10y)

gen Ch2yMinus3m = Ch2y - Ch3m
gen Ch10yMinus2y = Ch10y - Ch2y
gen Ch10yMinus3m=Ch10y-Ch3m

save "$path/generated_data/MP_upd_JP.dta", replace


restore


// GB
preserve
import excel using "$path/raw_data/responses_v15b_w3090_MPDPCsum.xlsx", sheet("GB") firstrow clear

keep date Datetime_gmt Country response_qtGvtFut3m	response_GB2YZ	response_qtGvtFutLong response_qtGvtFut3mNew

format date %td

// To keep the start date the same as the previous version: 
keep if date>=td(07jan1999)

rename response_qtGvtFut3m Ch3m
rename response_GB2YZ Ch2y
rename response_qtGvtFutLong Ch10y

// Data only has response_qtGvtFut3mNew after 16dec2021. For overlaps before, choose response_qtGvtFut3m
replace Ch3m=response_qtGvtFut3mNew if date>=td(16dec2021)

replace Ch3m=0 if missing(Ch3m)
replace Ch2y=0 if missing(Ch2y)
replace Ch10y=0 if missing(Ch10y)

gen Ch2yMinus3m = Ch2y - Ch3m
gen Ch10yMinus2y = Ch10y - Ch2y
gen Ch10yMinus3m=Ch10y-Ch3m

save "$path/generated_data/MP_upd_GB.dta", replace

restore

////// Append all
use "$path/generated_data/MP_upd_US.dta",clear

foreach j in EU JP GB {
	append using "$path/generated_data/MP_upd_`j'.dta"
}

replace Country="ECB" if Country=="EU"
replace Country="Fed" if Country=="US"
replace Country="BoE" if Country=="GB"
replace Country="BoJ" if Country=="JP"


// Create the cross-country MP shocks
gen yq=qofd(date)
format yq %tq
drop if missing(yq)

*gen Ch10yMinus3m=Ch10y-Ch3m
collapse (sum) Ch3m Ch2y Ch10y Ch2yMinus3m Ch10yMinus2y Ch10yMinus3m,by(yq Country)

foreach x of varlist Ch3m Ch2y Ch10y Ch2yMinus3m Ch10yMinus2y Ch10yMinus3m {
replace `x'=`x'/10000
}

rename Ch* Ch*_

keep if yq>tq(2004q2)

reshape wide Ch3m_ Ch2y_ Ch10y_ Ch2yMinus3m_ Ch10yMinus2y_ Ch10yMinus3m_, i(yq) j(Country,s)

order yq *_Fed *_ECB *_BoJ *_BoE

foreach i in Fed ECB BoE BoJ {
format Ch3m_`i' %9.0g
format Ch2y_`i' %9.0g
format Ch10y_`i' %9.0g
}


save "$path/generated_data/mon_pol_shocks_v202507.dta",replace

foreach j in "US" "EU" "GB" "JP" { 
erase "$path/generated_data/MP_upd_`j'.dta"
}


////// Create Broad Nominal Exchange Rate dataset

import excel using "$path/raw_data/Broad_currency_index_updated.xlsx", sheet("Nominal") cellrange(A1:BI369) firstrow clear

rename * NB*
rename NBA A
gen yq=qofd(A)	
format yq %tq

collapse NBUS NBXM NBJP NBGB, by(yq)
	
tsset yq
gen usd_ret=(ln(NBUS)-ln(l.NBUS))*100
gen eur_ret=(ln(NBXM)-ln(l.NBXM))*100
gen jpy_ret=(ln(NBJP)-ln(l.NBJP))*100
gen gbp_ret=(ln(NBGB)-ln(l.NBGB))*100

save "$path/generated_data/broad_nominal_FX_v202507.dta",replace
