***********************************************************************
* Project: The Demand for Government Debt – Euro Area            *
* Description:                                                        *
* This script constructs an annual dataset on euro area government    *
* bond holdings by sector, merged with macroeconomic indicators such  *
* as GDP and debt-to-GDP ratio.                                       *
***********************************************************************

clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/
//////////////////////////////////////////
//////// Euro area   /////////////////////
//////////////////////////////////////////

import excel using "$path/raw_data/Euroarea_holdings_data_updated.xlsx", sheet("EA_holdings_short") firstrow clear
destring A,replace
rename A year
tsset year

foreach x of varlist ROW Centralbank OtherFI MFI Nonfinancial  Total {
replace `x'=`x'/1000000
}

// Get GDP 

/*
preserve

set fredkey 2f2fb8729294c4714471cd4d993ad7f7,perm
	import fred EUNNGDP, daterange(1999-01-01 2024-09-23) aggregate(annual,eop) clear
		
	gen year=yofd(daten)	

	tsset year
	
	gen EAGDP=(EUNNGDP*4)/1000000
	
	tempfile fred
	save `fred',replace
	save "$path/generated_data/EU_FRED.dta",replace
	*saved on July 16, 2025.
restore

merge m:1 year using `fred',nogen	
*/
merge m:1 year using "$path/generated_data/EU_FRED.dta",nogen

gen debt_gdp_ea=(Total/EAGDP)


tsset year

save "$path/generated_data/EA_data_v202507.dta", replace

