***********************************************************************
* Project: The Demand for Government Debt – Japan                *
* Description:                                                        *
* This script constructs a quarterly dataset on Japanese government   *
* bond (JGB) holdings by sector, merged with macroeconomic indicators,*
* interest rates, and monetary policy shock measures.                 *
***********************************************************************

clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/

//////////////////////////////////////////
//////// Japan  //////////////////////////
//////////////////////////////////////////

//////////////////////////////////////////
//// BoJ FoF Data on Holdings  -  these are the ones being used in Motivation Graphs. 

import excel using "$path/raw_data/JGB_holdings_data_updated.xlsx", firstrow clear

replace q = 1 if q == 3
replace q = 2 if q == 6
replace q = 3 if q == 9
replace q = 4 if q == 12
gen yq = yq(year, q)
format yq %tq

drop Total 
rename JGBsTnJPY Total 
rename Depositorycorporations Banks
rename Insuranceandpensionfunds ICPF
rename Overseas ROW
rename Households HH
tsset yq

gen pre_qqe=(yq<=tq(2013q1))
gen post_qqe=(yq>=tq(2013q2) & year<=2019)
gen post_covid=year>=2020


foreach x of varlist  Centralbank-Others  {
	gen `x'vol = (`x'/100)*Total
}


foreach x of varlist  Centralbank-Others  {
	rename `x' shr_`x'
	rename `x'vol `x'
}


//////////////////////////////////////////
// Merge with FRED data - Get BoJ Assets and VIX and US interest rates
/*
preserve

set fredkey 2f2fb8729294c4714471cd4d993ad7f7,perm
	import fred JPNASSETS VIXCLS THREEFY5 THREEFY8, daterange(1966-01-01 2024-09-23) aggregate(quarter,eop) clear
		
	gen yq=qofd(daten)	

	tsset yq
	
	tempfile fred
	save `fred',replace
	save "$path/generated_data/JP_FRED.dta",replace
	*saved on July 17, 2025.

restore

merge m:1 yq using `fred',nogen	
*/
merge m:1 yq using "$path/generated_data/JP_FRED.dta",nogen

//////////////////////////////////////////


//////////////////////////////////////////
// Merge with BBG data - Get Yields, Nikkei Return - Get this data from Alexis

preserve 
import excel using "$path/raw_data/DBSonline_BBG_JP_updated.xlsx", firstrow clear sheet("data") 

rename JapanTBills3Month  GJTB3MO
rename JapanGovt1YSimpleYield GJGB1
rename JapanGovt2YSimpleYield GJGB2
rename JapanGovt5YSimpleYield GJGB5
rename JapanGovt10Yr  GJGB10
rename JapanGovt20YSimpleYield GJGB20
rename JapanGovt30YSimpleYield GJGB30
rename JPYUSDBS3Mv3M1Y USDJPYCIP1y
rename NIKKEI225PX_LAST NIKKEI

gen yq=qofd(A)	

collapse G* USDJPYCIP1y NIKKEI,by(yq)

tsset yq

gen nikkei_ret=(ln(NIKKEI)-ln(l.NIKKEI))*100
replace USDJPYCIP1y = -USDJPYCIP1y/100

keep yq G* NIKKEI nikkei_ret USDJPYCIP1y

tempfile jp_bbg
save `jp_bbg'
restore

merge 1:1 yq using `jp_bbg',nogen

//////////////////////////////////////////

//////////////////////////////////////////
// Merge with Macro data - Get Debt to GDP, GDP, CPI - Get this data from BIS Economic Dashboards (DBSOnline)

preserve
import excel using "$path/raw_data/DBSonline_MACRO_JP_updated.xlsx", firstrow clear sheet("data") cellrange(A2:P314)

rename BIS_MACROQFKKAJPP1 debt_gdp_jp
rename BIS_MACROQRBGBJPSZ GDP
rename BIS_MACROQVEBAJPLZ CPI

gen yq=qofd(A)
format yq %tq

tsset yq

gen inf_jp=(ln(CPI)-ln(l.CPI))*100

keep yq debt_gdp_jp GDP CPI inf_jp

tempfile jp_macro
save `jp_macro'
restore

merge 1:1 yq using `jp_macro',nogen


/////////////////////////////////////////


// ZC rates
preserve
import excel using "$path/raw_data/data_ZCYield.xlsx", firstrow clear sheet("JP") 
gen yq = qofd(dofc(Date))

format yq %tq

bys yq: gen h=_n
bys yq: gen H=_N
keep if h==H

tsset yq
drop Date

tempfile zc
save `zc'
restore

merge 1:1 yq using `zc',nogen

//////////////////////////////////////////

// Add JP MP shocks from High-frequency identification of monetary policy shocks in Japan by Hiroyuki Kubota & Mototsugu Shintani ; https://link.springer.com/article/10.1007/s42973-021-00110-x



preserve

import excel using "$path/raw_data/MP_shocks_other", firstrow clear sheet("BOJ2_Q") 
gen yq = yq(Year, Quarter)
format yq %tq

keep yq TARGET PATH
order yq TARGET PATH

rename TARGET BOJ_KS_Target
rename PATH BOJ_KS_Path


tempfile boj_ks
save `boj_ks',replace

restore

merge 1:1 yq using `boj_ks',nogen


tsset yq

save "$path/generated_data/JP_data_v202507.dta", replace


/*
// Volumes

gen a_1=Centralbank
gen a_2= a_1 + Banks
gen a_3=a_2 + ICPF
gen a_4=a_3 + ROW
gen a_5=a_4 + Publicpensions
gen a_6=a_5 + HH
gen a_7=a_6 + Others

label var a_1 "Central bank"
label var a_2 "Banks"
label var a_3 "ICPF"
label var a_4 "ROW"
label var a_5 "Public Pensions" 
label var a_6 "HH"
label var a_7 "Others"

cap gen Covid=1100
foreach i of numlist `=tq(2020q1)' {
	cap gen y`i'=`i'
}

cap gen GFC=1100
foreach i of numlist `=tq(2008q3)' {
	cap gen y`i'=`i'
}

cap gen QQE=1100
foreach i of numlist `=tq(2013q1)' {
	cap gen y`i'=`i'
}


local y=tq(2000q1)
twoway   (area a_7 yq, bcolor(black*0.1)) (area a_6 yq, bcolor(black*0.2)) (area a_5 yq, bcolor(black*0.3)) (area a_4 yq, bcolor(black*0.4)) ///
  (area a_3 yq, bcolor(black*0.6)) (area a_2 yq, bcolor(black*0.8)) ///
  (area a_1 yq, bcolor(black)) (dropline GFC y`=tq(2008q3)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline Covid y`=tq(2020q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QQE y`=tq(2013q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  if year>=`y', ytitle("¥ trillions") xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
  legend(rows(2) order(7 6 5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4))  ///
  text(1150 `=tq(2020q1)' "Covid-19") text(1150 `=tq(2008q3)' "GFC") text(1150 `=tq(2013q1)' "QQE") ylabel(0(200)1100)
graph export "$path/Data/analysis/graphs_paper/JP_volumes.pdf",replace


// Shares

gen b_1=shr_Centralbank
gen b_2=b_1 + shr_Banks
gen b_3=b_2 + shr_ICPF
gen b_4=b_3 + shr_ROW
gen b_5=b_4 + shr_Publicpensions
gen b_6=b_5 + shr_HH
gen b_7=b_6 + shr_Others

label var b_1 "Central bank"
label var b_2 "Banks"
label var b_3 "ICPF"
label var b_4 "ROW"
label var b_5 "Public Pensions" 
label var b_6 "HH"
label var b_7 "Others"

cap gen Covid_2=100
foreach i of numlist `=tq(2020q1)' {
	cap gen y`i'=`i'
}

cap gen GFC_2=100
foreach i of numlist `=tq(2008q3)' {
	cap gen y`i'=`i'
}

cap gen QQE_2=100
foreach i of numlist `=tq(2013q1)' {
	cap gen y`i'=`i'
}

local y=tq(2000q1)
twoway   (area b_7 yq, bcolor(black*0.1)) (area b_6 yq, bcolor(black*0.2)) (area b_5 yq, bcolor(black*0.3)) (area b_4 yq, bcolor(black*0.4)) ///
  (area b_3 yq, bcolor(black*0.6)) (area b_2 yq, bcolor(black*0.8)) ///
  (area b_1 yq, bcolor(black)) (dropline GFC_2 y`=tq(2008q3)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline Covid_2 y`=tq(2020q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QQE_2 y`=tq(2013q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  if year>=`y', ytitle("Per cent") xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
  legend(rows(2) order(7 6 5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4))  ///
  text(103 `=tq(2020q1)' "Covid-19") text(103 `=tq(2008q3)' "GFC") text(103 `=tq(2013q1)' "QQE")
graph export "$path/Data/analysis/graphs_paper/JP_shares.pdf",replace


// Regressions

foreach x of varlist Centralbank-Others Total {
	
	gen d`x'=d.`x'
}

foreach x of varlist Centralbank-Others Total {
	
		gen d`x'_n = d`x'/l.Total
}

gen tot_preqqe=dTotal_n*pre_qqe
gen tot_postqqe=dTotal_n*post_qqe
gen tot_pc=dTotal_n*post_covid


**** Marginal holders of JGBs

local format = "nocons nonotes dec(2) label"

local reg_table = "$path/Data/analysis/tables_paper/JP_marginal_holders"
cap erase "`reg_table'.tex"
cap erase "`reg_table'.txt"

newey dCentralbank_n tot_preqqe tot_postqqe tot_pc ,lag(4)

outreg2 using "`reg_table'.tex", tex(frag) replace `format' 

foreach x of varlist dBanks_n-dOthers_n  {
	
newey `x' tot_preqqe tot_postqqe tot_pc ,lag(4)
outreg2 using "`reg_table'.tex", tex(frag) append `format'

}

cap erase "`reg_table'.txt"
