***********************************************************************
* Project: The Demand for Government Debt – United Kingdom           *
* Description:                                                       *
* This script constructs data for analyzing the demand for UK        *
* government debt using sectoral holdings and monetary policy        *
* shocks. It applies valuation adjustments, creates PCA instruments,*
* runs first-stage and second-stage regressions, and generates       *
* associated regression tables.                                      *
***********************************************************************

clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

// Clean and transform variables for elasticity regressions
use "$path/generated_data/mon_pol_shocks_v202507.dta",clear
merge 1:1 yq using "$path/generated_data/broad_nominal_FX_v202507.dta",nogen
merge 1:1 yq using "$path/generated_data/UK_data_v202507.dta",nogen

tsset yq


//Generate logs and log changes

// Holding data
foreach x of varlist ICPF MFI Centralbank ROW OFI HH AllOther {
gen dln_`x'=ln(`x')-ln(l.`x')
gen ln_`x'=ln(`x')
}

// Valuation changes - assuming everyone holds X-year zero coupon bonds.

gen val_ch10_pct=-(d.GB_10Y/100)*10
gen val_ch8_pct=-(d.GB_8Y/100)*8
gen val_ch5_pct=-(d.GB_5Y/100)*5


foreach x of varlist ICPF MFI Centralbank ROW OFI HH AllOther {
	foreach i in 5 8 10 {
gen val_ch`i'_`x'= l.`x'*val_ch`i'_pct
gen `x'_exval`i'=`x'-val_ch`i'_`x'
gen ln_`x'_exval`i'=ln(`x'_exval`i')
gen dln_`x'_exval`i'=ln(`x'_exval`i')-ln(l.`x'_exval`i')
}
}
///////

foreach y of varlist UKNGDP VIXCLS BoE_gbp NBGB CPI {
gen dln_`y'=ln(`y')-ln(l.`y')
gen ln_`y'=ln(`y')
}


// Interest rates
*foreach t of varlist THREE* DGS* inf_exc_fe stock_ret usd_ret ffr spread_ig spread_aaa sp_div_yield german_5y_zc german_10y_zc {
	foreach t of varlist GB_* inf_uk ftse_ret gbp_ret THREEFY5 THREEFY8 {

gen dir_`t'=`t'/100-l.`t'/100
gen ir_`t'=`t'/100
gen dln_`t'=ln(1+`t'/100)-ln(1+l.`t'/100)
gen ln_`t'=ln(1+`t'/100)

}

// Mon pol shocks
foreach t of varlist Ch* {
gen dln_`t'=ln(1+`t')-ln(1+l.`t')
gen ln_`t'=ln(1+`t')
gen dir_`t'=`t'-l.`t'
gen ir_`t'=`t'
}

// Principal components
tsset yq

pca BOE_BMAS*
predict p1_boe_bmas

pca ir_Ch3m_BoE ir_Ch2y_BoE ir_Ch10y_BoE
predict p1_boe_ksx

pca BOE_BMAS* ir_Ch3m_BoE ir_Ch2y_BoE ir_Ch10y_BoE
predict p1_boe_bmas_ksx

foreach mps in "p1_boe_ksx" "p1_boe_bmas_ksx" "p1_boe_bmas" "BOE_BMAS_QE"{

egen std_`mps'=std(`mps')

}


global ln_controls "ln_UKNGDP dln_UKNGDP ir_inf_uk ln_NBGB ln_VIXCLS ir_ftse_ret ir_THREEFY8 yq yq_sq" 

gen yq_sq=yq^2


label var ir_GB_8Y "UK 8Y Yield (ZC)"
label var std_p1_boe_bmas "PCA 1 BOE (BMAS)"
label var std_p1_boe_bmas_ksx "PCA 1 BOE (BMAS, KSX)"
label var std_p1_boe_ksx "PCA 1 BOJ (KSX)"
label var std_BOE_BMAS_QE "BOE BMAS QE"
label var BOE_BMAS_Target "BOE BMAS Target"
label var BOE_BMAS_Path "BOE BMAS Path"
label var BOE_BMAS_QE "BOE BMAS QE"

label var ir_Ch3m_BoE "BOE KSX 3m"
label var ir_Ch2y_BoE "BOE KSX 2y"
label var ir_Ch10y_BoE "BOE KSX 10y"


label var ln_MFI_exval8 "log(MFI)"
label var ln_ICPF_exval8 "log(ICPF)"
label var ln_ROW_exval8 "log(ROW)"
label var ln_HH_exval8 "log(HH)"
label var ln_OFI_exval8 "log(OFI)"
label var ln_AllOther_exval8 "log(Others)"

/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////        FIRST STAGE REGRESSIONS      //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////// FIRST STAGE ///////////////////////////////

/// Create locals for the effective F-stats for various instruments

local mp1 BOE_BMAS_Path BOE_BMAS_Target BOE_BMAS_QE
local text1 = "addtext(Trend, Yes, Controls, No, Sample, 2004q3-2024q1)"
local text1_wc = "addtext(Trend, Yes, Controls, Yes, Sample, 2004q3-2024q1)"

local mp2 ir_Ch3m_BoE ir_Ch2y_BoE ir_Ch10y_BoE
local text2 = "addtext(Trend, Yes, Controls, No, Sample, 2004q3-2024q1)"
local text2_wc = "addtext(Trend, Yes, Controls, Yes, Sample, 2004q3-2024q1)"

local mp3 std_p1_boe_bmas
local text3 = "addtext(Trend, Yes, Controls, No, Sample, 2004q3-2024q1)"
local text3_wc = "addtext(Trend, Yes, Controls, Yes, Sample, 2004q3-2024q1)"

local mp4 std_p1_boe_ksx
local text4 = "addtext(Trend, Yes, Controls, No , Sample, 2004q3-2024q1)"
local text4_wc = "addtext(Trend, Yes, Controls, Yes , Sample, 2004q3-2024q1)"

local mp5 std_p1_boe_bmas_ksx
local text5 = "addtext(Trend, Yes, Controls, No, Sample, 2004q3-2024q1)"
local text5_wc = "addtext(Trend, Yes, Controls, Yes, Sample, 2004q3-2024q1)"

local mp6 BOE_BMAS_QE
local text6 = "addtext(Trend, Yes, Controls, No , Sample, 2004q3-2024q1)"
local text6_wc = "addtext(Trend, Yes, Controls, Yes , Sample, 2004q3-2024q1)"



forvalues i=1/6 {
	
	/*
	// Without any controls
	qui ivreg2 ln_ROW_exval8 (ir_GB_8Y=`mp`i'') yq yq_sq if inrange(yq,tq(2004q3), tq(2024q1)),robust bw(auto)  ffirst
	qui weakivtest
	
	local weak`i' = `r(F_eff)'
	local crt`i'=`r(c_TSLS_10)'
	*/
	// With controls
	qui ivreg2 ln_ROW_exval8 (ir_GB_8Y=`mp`i'') $ln_controls if inrange(yq,tq(2004q3), tq(2024q1)),robust bw(auto)  ffirst
	qui weakivtest
	
	local weak`i'_wc = `r(F_eff)'
	local crt`i'_wc=`r(c_TSLS_10)'
	/*
	local format_fs`i' = "label addstat(Effective F-stat, `weak`i'', Crt. Val. \$ \alpha=5%$ and \$ \tau=10%$, `crt`i'') adec(2) nonotes nocons keep(std_p1_boe_bmas std_p1_boe_bmas_ksx std_p1_boe_ksx std_BOE_BMAS_QE) sortvar(std_p1_boe_bmas std_p1_boe_bmas_ksx std_p1_boe_ksx std_BOE_BMAS_QE)"
	*/
	local format_fs`i'_wc= "label addstat(Effective F-stat, `weak`i'_wc', Crt. Val. \$ \alpha=5%$ and \$ \tau=10%$, `crt`i'_wc') adec(2) nonotes nocons keep(BOE_BMAS_Path BOE_BMAS_Target BOE_BMAS_QE ir_Ch3m_BoE ir_Ch2y_BoE ir_Ch10y_BoE std_p1_boe_bmas std_p1_boe_ksx std_p1_boe_bmas_ksx ) sortvar(BOE_BMAS_Path BOE_BMAS_Target BOE_BMAS_QE ir_Ch3m_BoE ir_Ch2y_BoE ir_Ch10y_BoE std_p1_boe_bmas std_p1_boe_ksx std_p1_boe_bmas_ksx )"

}


//// First stage table -  BASELINE

local table = "$path/tables_paper/MaSc_GB_pca_fs"
cap erase "`table'.tex"
cap erase "`table'.txt"

/*
forvalues i=1/5 {
	
		ivreg2 ir_GB_8Y `mp`i''  yq yq_sq if inrange(yq,tq(2004q3), tq(2024q1)), robust bw(auto)  ffirst
		outreg2 using "`table'.tex", tex(frag) append `format_fs`i'' dec(4) `text`i''

}
*/
forvalues i=1/6 {
	
		ivreg2 ir_GB_8Y `mp`i'' $ln_controls if inrange(yq,tq(2004q3), tq(2024q1)), robust bw(auto)  ffirst
		outreg2 using "`table'.tex", tex(frag) append `format_fs`i'_wc' dec(4) `text`i'_wc'

}


cap erase "`table'.txt"


// Second stage - USE BMAS QE as it has the best first stage.


local format = "label nor2  addstat(Anderson-Rubin Wald test (p-val), e(archi2p), Underidentification LM stat (p-val), e(idp)) adec(2) nonotes nocons sortvar(ir_GB_8Y) keep(ir_GB_8Y) "
*local format_overid = "label nor2  addstat(Anderson-Rubin Wald test (p-val), e(archi2p), Underidentification LM stat (p-val), e(idp), Hansen J stat (p-val), e(jp)) adec(2) nonotes nocons sortvar(ir_THREEFY8) keep(ir_THREEFY8) "

*local format_wc = "label nor2  addstat(Anderson-Rubin Wald test (p-val), e(archi2p), Underidentification LM stat (p-val), e(idp)) adec(2) nonotes nocons sortvar(ir_THREEFY8)"

local text_ss1 = "addtext(Trend, Yes, Controls,  Yes)"

local table = "$path/tables_paper/MaSc_GB_pca_2sls"
cap erase "`table'.tex"
cap erase "`table'.txt"

/// Second stage table - BASELINE

*foreach x of varlist ln_row_fo_exval8 ln_row_fp_exval8 ln_IF_exval8 ln_Banks_exval8 ln_PF_exval8 ln_IC_exval8  ln_HH_exval8 ln_SLG_exval8 ln_Other_exval8 {
	
foreach x of varlist ln_ROW_exval8 ln_MFI_exval8 ln_OFI_exval8 ln_HH_exval8 ln_ICPF_exval8 ln_AllOther_exval8 {

ivreg2 `x' (ir_GB_8Y=BOE_BMAS_QE) $ln_controls if inrange(yq,tq(2004q3), tq(2024q1)), robust bw(auto)  ffirst
outreg2 using "`table'.tex", tex(frag) append `format' dec(2) `text_ss1'

}

cap erase "`table'.txt"

