
***********************************************************************
* Project: The Demand for Government Debt – Euro Area           *
* Description:                                                        *
* This script loads and analyzes annual data on Euro Area sovereign  *
* bond holdings by sector. It generates stacked area charts for both *
* volumes and shares, and runs regressions to estimate marginal       *
* buyers across QE regimes.                                           *
***********************************************************************
clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/


//////////////////////////////////////////
//////// Euro Area //////////////////////////
//////////////////////////////////////////

use "$path/generated_data/EA_data_v202507.dta", clear
keep if !missing(Total)
keep if inrange(year,2001,2023)

// Volumes

gen a_1=Centralbank 
gen a_2= a_1 + ROW
gen a_3=a_2 + MFI
gen a_4=a_3 + OtherFI
gen a_5=a_4 + Nonfinancial

label var a_1 "Central bank"
label var a_2 "ROW"
label var a_3 "MFI"
label var a_4 "Other FI"
label var a_5 "NonFin"

label var debt_gdp_ea "Debt/GDP (per cent)"
/*
cap gen Covid=12
foreach i of numlist 2019 {
	cap gen y`i'=`i'
}

cap gen GFC=12
foreach i of numlist 2008 {
	cap gen y`i'=`i'
}
*/
cap gen QE=12
foreach i of numlist 2014 {
	cap gen y`i'=`i'
}


local y=2000
twoway   (area a_5 year, bcolor(black*0.2)) (area a_4 year, bcolor(black*0.4))  (area a_3 year, bcolor(black*0.6)) (area a_2 year, bcolor(black*0.8))  ///
(area a_1 year, bcolor(black)) /// (line debt_gdp_ea year, yaxis(2) lcolor(black) lpattern(dash) lwidth(medthick)) ///
 (dropline QE y2014, lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
if year>=`y', ytitle("€ trillions") xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
legend(rows(1) order(5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4)) text(12.5 2014 "QE") ylabel(0(4)12)
graph export "$path/graphs_paper/EU_volumes.pdf",replace

// Shares

foreach x of varlist ROW Centralbank OtherFI MFI Nonfinancial {
gen shr_`x'=(`x'/Total)*100
}

gen b_1=shr_Centralbank 
gen b_2= b_1 + shr_ROW
gen b_3=b_2 + shr_MFI
gen b_4=b_3 + shr_OtherFI
gen b_5=b_4 + shr_Nonfinancial

label var b_1 "Central bank"
label var b_2 "ROW"
label var b_3 "MFI"
label var b_4 "Other FI"
label var b_5 "NonFin"

/*
cap gen Covid_2=100
foreach i of numlist 2019 {
	cap gen y`i'=`i'
}

cap gen GFC_2=100
foreach i of numlist 2008 {
	cap gen y`i'=`i'
}
*/
cap gen QE_2=100
foreach i of numlist 2014 {
	cap gen y`i'=`i'
}


local y=2000
twoway   (area b_5 year, bcolor(black*0.2)) (area b_4 year, bcolor(black*0.4))  (area b_3 year, bcolor(black*0.6)) (area b_2 year, bcolor(black*0.8))  ///
(area b_1 year, bcolor(black)) (dropline QE_2 y2014, lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
 if year>=`y', ytitle("Per cent") xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
 legend(rows(1) order(5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4)) text(105 2014 "QE") ylabel(0(20)100)
graph export "$path/graphs_paper/EU_shares.pdf",replace


// Regressions
tsset year

gen pre_qe=(year<=2014)
gen post_qe=year>2014

foreach x of varlist Centralbank ROW OtherFI MFI Nonfinancial Total {
	gen d`x'=d.`x'
}


foreach x of varlist Centralbank ROW OtherFI MFI  Nonfinancial Total {
		gen d`x'_n = d`x'/l.Total
}

gen tot_preqe=dTotal_n*pre_qe
gen tot_postqe=dTotal_n*post_qe

**** Marginal holders of EU Government Bonds
label var dCentralbank_n "CB"
label var dROW_n "ROW"
label var dNonfinancial_n "NonFin"
label var dMFI_n "MFI"
label var dOtherFI_n "OtherFI"

label var tot_preqe "Pre-QE * Pct. Ch. Gov. Debt"
label var tot_postqe "Post-QE * Pct. Ch. Gov. Debt"


local format = "nocons nonotes dec(2) label"

local reg_table = "$path/tables_paper/EU_marginal_holders"
cap erase "`reg_table'.tex"
cap erase "`reg_table'.txt"

ivreg2 dCentralbank_n tot_preqe tot_postqe,bw(auto)

outreg2 using "`reg_table'.tex", tex(frag) replace `format' 

foreach x of varlist dROW_n dOtherFI_n dMFI_n dNonfinancial_n {
	
ivreg2 `x'  tot_preqe tot_postqe,robust bw(auto)
outreg2 using "`reg_table'.tex", tex(frag) append `format'

}

cap erase "`reg_table'.txt"




/// averages
preserve
gen y=.
replace y=1 if pre_qe
replace y=2 if post_qe 
collapse shr_*,by(y)

rename y shr_y

foreach var of varlist _all {

replace `var'=round(`var',0.1)

}

rename shr_* *
rename Centralbank CB
rename Nonfinancial NonFin

label var y "Avg. Share"
label define time 1 "Pre-QE" 2 "Post-QE" 
label values y time

order y CB ROW OtherFI MFI NonFin 

estpost tabstat CB ROW OtherFI MFI NonFin, by(y) nototal
esttab using  "$path/tables_paper/EU_avg_by_time.tex", cells("CB ROW OtherFI MFI NonFin") noobs nomtitle nonumber varwidth(30) collab(, lhs("`:var lab y'")) tex replace
restore
