
***********************************************************************
* Project: The Demand for Government Debt – United Kingdom       *
* Description:                                                        *
* This script loads and analyzes quarterly data on UK government      *
* bond holdings by sector. It generates time-series graphs of volume *
* and share composition, and runs regressions on the marginal         *
* response of sectoral holdings to changes in government debt.        *
***********************************************************************
clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/

//////////////////////////////////////////
//////// United Kingdom  //////////////////////////
//////////////////////////////////////////

use "$path/generated_data/UK_data_v202507.dta", clear
keep if !missing(Total)

keep if inrange(yq,tq(2001q1),tq(2024q2))

//////////////////////////////////////////
//////////////////////////////////////////
//    Graphs
//////////////////////////////////////////
//////////////////////////////////////////

	//////////////////////////////////////////
	// Volumes
	//////////////////////////////////////////
	
gen a_1=Centralbank
gen a_2=a_1+ MFI
gen a_3=a_2 + ROW
gen a_4=a_3 + ICPF
gen a_5=a_4 + OFI
gen a_6=a_5 + HH
gen a_7=a_6 + AllOther

label var a_1 "Central bank"
label var a_2 "MFI"
label var a_3 "ROW"
label var a_4 "ICPF"
label var a_5 "Other FI"
label var a_6 "HH" 
label var a_7 "All other"

label var debt_gdp_uk "Debt/GDP (per cent)"

/*
gen a_1=Centralbank 
gen a_2=a_1 + ROW
gen a_3=a_2 + ICPF
gen a_4=a_3 + OFI
gen a_5=a_4 + MFI
gen a_6=a_5 + HH
gen a_7=a_6 + AllOther

label var a_1 "Central bank"
label var a_2 "ROW"
label var a_3 "ICPF"
label var a_4 "Other FI"
label var a_5 "MFIs"
label var a_6 "HH" 
label var a_7 "All other"
*/

cap gen Covid=2.7
foreach i of numlist `=tq(2020q1)' {
	cap gen y`i'=`i'
}

cap gen QE=2.7
foreach i of numlist `=tq(2009q1)' {
	cap gen y`i'=`i'
}

cap gen QT_p=2.7 
foreach i of numlist `=tq(2021q4)' {
	cap gen y`i'=`i'
}

cap gen QT_a=2.7 
foreach i of numlist `=tq(2022q4)' {
	cap gen y`i'=`i'
}

/*
local y=tq(2001q1)
twoway   (area a_7 yq, bcolor(black*0.1))  (area a_6 yq, bcolor(black*0.2)) (area a_5 yq, bcolor(black*0.3)) ///
  (area a_4 yq, bcolor(black*0.4))  (area a_3 yq, bcolor(black*0.6)) (area a_2 yq, bcolor(black*0.7)) ///
  (area a_1 yq, bcolor(black)) (dropline QE y`=tq(2009q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (line debt_gdp_uk yq, yaxis(2) lcolor(black) lpattern(dash) lwidth(medthick)) ///
  (dropline Covid y`=tq(2020q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QT_p y`=tq(2021q4)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QT_a y`=tq(2022q4)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  if yq>=`y', ytitle("£ trillions") xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
  legend(rows(2) order(7 6 5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4))  ///
  text(2.85 `=tq(2020q1)' "Covid-19") text(2.7 `=tq(2009q1)' "QE") text(2.7 `=tq(2021q4)' "QT(P)") text(2.85 `=tq(2022q4)' "QT(A)") ylabel(0(0.5)2.7)
graph export "$path/graphs_paper/UK_volumes.pdf",replace
*/


local y=tq(2001q1)
twoway   (area a_7 yq, bcolor(black*0.1))  (area a_6 yq, bcolor(black*0.2)) (area a_5 yq, bcolor(black*0.3)) ///
  (area a_4 yq, bcolor(black*0.4))  (area a_3 yq, bcolor(black*0.6)) (area a_2 yq, bcolor(black*0.7)) ///
  (area a_1 yq, bcolor(black)) (dropline QE y`=tq(2009q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) /// (line debt_gdp_uk yq, yaxis(2) lcolor(black) lpattern(dash) lwidth(medthick)) ///
  (dropline Covid y`=tq(2020q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QT_p y`=tq(2021q4)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QT_a y`=tq(2022q4)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  if yq>=`y', ytitle("£ trillions") xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
  legend(rows(2) order(7 6 5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4))  ///
  text(2.85 `=tq(2020q1)' "Covid-19") text(2.7 `=tq(2009q1)' "QE") text(2.7 `=tq(2021q4)' "QT(P)") text(2.85 `=tq(2022q4)' "QT(A)") ylabel(0(0.5)2.7)
graph export "$path/graphs_paper/UK_volumes.pdf",replace

	//////////////////////////////////////////
	// Shares
	//////////////////////////////////////////
	
foreach x of varlist Centralbank ROW ICPF MFI OFI HH AllOther {
gen shr_`x'=(`x'/Total)*100
}

// Note: the graph looks funny because of negative positions of MFIs pre-GFC. That is due to their market making/prop trading activities - need a footnote to explain this. 

gen b_1= shr_Centralbank
gen b_2=b_1 + shr_MFI
gen b_3=b_2 + shr_ROW
gen b_4=b_3 + shr_ICPF
gen b_5=b_4 + shr_OFI
gen b_6=b_5 + shr_HH
gen b_7=b_6 + shr_AllOther

label var b_1 "Central bank"
label var b_2 "MFI"
label var b_3 "ROW"
label var b_4 "ICPF"
label var b_5 "Other FI"
label var b_6 "HH" 
label var b_7 "All other"
/*
gen b_1=shr_Centralbank 
gen b_2=b_1 + shr_ROW
gen b_3=b_2 + shr_ICPF
gen b_4=b_3 + shr_OFI
gen b_5=b_4 + shr_MFI
gen b_6=b_5 + shr_HH
gen b_7=b_6 + shr_AllOther

label var b_1 "Central bank"
label var b_2 "ROW"
label var b_3 "ICPF"
label var b_4 "Other FI"
label var b_5 "MFIs"
label var b_6 "HH" 
label var b_7 "All other"
*/
cap gen Covid_2=100
foreach i of numlist `=tq(2020q1)' {
	cap gen y`i'=`i'
}

cap gen QE_2=100
foreach i of numlist `=tq(2009q1)' {
	cap gen y`i'=`i'
}


cap gen QT_p_2=100
foreach i of numlist `=tq(2021q4)' {
	cap gen y`i'=`i'
}

cap gen QT_a_2=100
foreach i of numlist `=tq(2022q4)' {
	cap gen y`i'=`i'
}

local y=tq(2001q1)
twoway  (area b_7 yq, bcolor(black*0.1)) (area b_6 yq, bcolor(black*0.2)) (area b_5 yq, bcolor(black*0.3)) ///
 (area b_4 yq, bcolor(black*0.4))  (area b_3 yq, bcolor(black*0.6)) (area b_2 yq, bcolor(black*0.7)) ///
  (area b_1 yq, bcolor(black)) (dropline QE_2 y`=tq(2009q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline Covid_2 y`=tq(2020q1)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QT_p_2 y`=tq(2021q4)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  (dropline QT_a_2 y`=tq(2022q4)', lcolor(red) mcolor(none) lwidth(thin) lpattern(dash_dot)) ///
  if yq>=`y', ytitle("Per cent" " " ) xtitle(" ") graphre(color(white))  ylabel(,nogrid) ///
  legend(rows(2) order(7 6 5 4 3 2 1) region(lwidth(none)) pos(bottom) col(5) size(*.9)  symxsize(*.4))  ///
  text(106 `=tq(2020q1)' "Covid-19") text(103 `=tq(2009q1)' "QE") text(101 `=tq(2021q4)' "QT(P)") text(106 `=tq(2022q4)' "QT(A)") 
graph export "$path/graphs_paper/UK_shares.pdf",replace

	//////////////////////////////////////////
	// Regressions
	//////////////////////////////////////////
	
tsset yq
gen pre_gfc=yq<tq(2009q1) &!missing(yq)
gen post_gfc=inrange(yq,tq(2009q1),tq(2019q4))
gen post_covid=inrange(yq,tq(2020q1),tq(2021q3))
gen qt=yq>tq(2021q4) & !missing(yq)

foreach x of varlist Centralbank ROW ICPF MFI HH OFI AllOther Total {
	
	gen d`x'=d.`x'
}

foreach x of varlist Centralbank ROW ICPF MFI HH OFI AllOther Total {
	
		gen d`x'_n = d`x'/l.Total
}

gen tot_beforegfc=dTotal_n*pre_gfc
gen tot_pgfc=dTotal_n*post_gfc
gen tot_pc=dTotal_n*post_covid
gen tot_qt=dTotal_n*qt


**** Marginal holders of UK Gilts


label var dCentralbank_n "CB"
label var dROW_n "ROW"
label var dICPF_n "ICPF"
label var dMFI_n "MFI"
label var dHH_n "HH"
label var dOFI_n "OFI"
label var dAllOther_n "All Other"

label var tot_beforegfc "Pre-GFC * Pct. Ch. Gov. Debt"
label var tot_pgfc "Post-GFC * Pct. Ch. Gov. Debt"
label var tot_pc "Post-Covid * Pct. Ch. Gov. Debt"
label var tot_qt "Post-QT * Pct. Ch. Gov. Debt"


local format = "nocons nonotes dec(2) label"

local reg_table = "$path/tables_paper/UK_marginal_holders"
cap erase "`reg_table'.tex"
cap erase "`reg_table'.txt"


ivreg2 dCentralbank_n tot_beforegfc tot_pgfc tot_pc tot_qt,bw(auto)

outreg2 using "`reg_table'.tex", tex(frag) replace `format' 

foreach x of varlist dROW_n dICPF_n dMFI_n dHH_n dOFI_n dAllOther_n  {
	
ivreg2 `x' tot_beforegfc tot_pgfc tot_pc tot_qt,robust bw(auto)
outreg2 using "`reg_table'.tex", tex(frag) append `format'

}

cap erase "`reg_table'.txt"



/// averages
preserve
gen y=.
replace y=1 if pre_gfc
replace y=2 if post_gfc
replace y=3 if post_covid
replace y=4 if qt

collapse shr_*,by(y)

rename y shr_y

foreach var of varlist _all {

replace `var'=round(`var',0.1)

}

rename shr_* *
rename Centralbank CB

label var y "Avg. Share"
label define time 1 "Pre-GFC" 2 "Post-GFC" 3 "Post-Covid" 4 "Post-QT"
label values y time

order y CB ROW ICPF MFI HH OFI AllOther 

estpost tabstat CB ROW ICPF MFI HH OFI AllOther , by(y) nototal
esttab using  "$path/tables_paper/UK_avg_by_time.tex", cells("CB ROW ICPF MFI HH OFI AllOther ") noobs nomtitle nonumber varwidth(30) collab(, lhs("`:var lab y'")) tex replace
restore
