*** This is the master do file that replicates Eren, Schrimpf and Xia (2025)

clear all
set more off

* Set path
foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_FINAL_202509/Replication" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_FINAL_202509\Replication"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 


log using "ESX_log.log", text replace

// Section 1: Create the country-specific datasets + add MP shocks

// Cross-country datasets

do "$path/create_cross_country_v202507.do" 

*********************************************************************
* Project: The Demand for Government Debt						   *
* Description:                                                      *
* This script processes high-frequency monetary policy surprise     *
* data for the US, Euro area, Japan, and UK, and builds a clean     *
* quarterly panel of policy shocks. It also calculates returns on   *
* broad nominal exchange rate indexes for major currencies.         *                                      
*********************************************************************

*-------------------------------------------------------------------*
* Main Features:
* - Imports and processes monetary policy shock series for:
*     > US (OIS + futures)
*     > Euro area (OIS + German futures)
*     > Japan (futures)
*     > UK (futures with regime switch in 3M series)
* - Computes interest rate spreads (2Y–3M, 10Y–2Y, 10Y–3M)
* - Aggregates raw daily shocks into quarterly frequency
* - Reshapes final shock panel to wide format by country
* - Creates broad nominal exchange rate returns for USD, EUR, JPY, GBP

*-------------------------------------------------------------------*
* Inputs (under $path/raw_data/):
* - responses_v15b_w3090_MPDPCsum.xlsx:
*     > Monetary policy shocks by country (sheets: US, EU, JP, GB)
* - Broad_currency_index_updated.xlsx:
*     > Broad nominal FX indexes (monthly), sheet "Nominal"

*-------------------------------------------------------------------*
* Outputs (under $path/generated_data/):
* - mon_pol_shocks_v202507.dta:
*     > Quarterly panel of MP shocks (wide format by country)
* - broad_nominal_FX_v202507.dta:
*     > Quarterly log returns of broad nominal FX indexes

*-------------------------------------------------------------------*
* Workflow Summary:
* 1. Import and rename shock series for each country (Ch3m, Ch2y, Ch10y)
* 2. Set missing shocks to zero (no surprise assumed)
* 3. Compute interest rate slope surprises:
*     - Ch2yMinus3m, Ch10yMinus2y, Ch10yMinus3m
* 4. Save country-specific datasets
* 5. Append all country datasets and standardize country names (Fed, ECB, etc.)
* 6. Collapse to quarterly frequency and scale shocks (from bps to decimals)
* 7. Reshape data to wide format by country and shock type
* 8. Clean up intermediate files
* 9. Import FX index data, collapse to quarterly, compute % log returns
* 10. Save final FX dataset

*-------------------------------------------------------------------*
* Notes:
* - All monetary policy surprises are scaled by 10,000 (bps to decimals)
* - FX returns are computed as 100 × log-difference of indexes
* - The 3M shock for UK switches to a new series post-Dec 2021
* - Final shock data includes six types per country:
*     > Ch3m, Ch2y, Ch10y, Ch2y–3m, Ch10y–2y, Ch10y–3m

*********************************************************************


// US 

do "$path/create_us_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – United States             *
* Description:                                                        *
* This script builds a comprehensive quarterly dataset on the U.S.    *
* Treasury market for use in regression analysis. It combines Flow of *
* Funds (FoF) holdings data, TIC foreign holdings, macro-financial    *
* indicators, monetary policy shocks, and valuation adjustments.      *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Imports and processes FoF data on UST holders (Fed + non-residents)
* - Constructs aggregate holdings by sector (banks, PF, IC, IF, SLG, HH, etc.)
* - Merges:
*     > TIC foreign official/private holdings
*     > Treasury issuance from MSPD
*     > Macroeconomic and financial variables from FRED (GDP, yields, CPI, etc.)
*     > Monetary policy shocks: BRW, Swanson, Jarocinski-Karadi, NS, KSX
*     > SP500 dividend yield, German zero-coupon yields
*     > IMF dollar share (global reserves)
* - Calculates valuation-adjusted holdings
* - Computes outside asset residuals and debt-only exposures
* - Constructs total and sector-specific ownership variables

*---------------------------------------------------------------------*
* Inputs (under $path/raw_data/):
* - Data.xlsx: Treasury holders (FoF)
* - USTHoldings_20240924.xlsx: TIC foreign holdings
* - MSPD_SumSecty_20010131_20241031.xlsx: Treasury supply
* - BRW2024-08.xlsx: Monetary policy surprises (BRW)
* - Swanson_shocks.xlsx: Fed factor decompositions
* - shocks_fed_jk_m_202409.xlsx: Jarocinski-Karadi MP shocks
* - MPshocksAcosta.xlsx: Nakamura-Steinsson (Acosta update)
* - outside_assets_updated.xlsx: S&P dividend yield, German ZC yields
* - IMFCOFER.xlsx: Dollar reserve share

* Pre-merged/generated:
* - FoF_fred_20240923.dta: Cleaned FoF + TIC holdings
* - US_FRED_macrofin.dta: FRED macro-financial indicators
* - US_FRED_FoF.dta: FRED-based sectoral asset totals
* - US_FRED_FoF_debt.dta: Sectoral debt securities data

*---------------------------------------------------------------------*
* Outputs (under $path/generated_data/):
* - US_data_v202507.dta:
*     > Final merged and labeled dataset for regressions

*---------------------------------------------------------------------*
* Workflow Summary:
* 1. Import cleaned FoF sectoral data (with precomputed aggregates)
* 2. Merge in:
*     - FRED macro and balance sheet series
*     - Treasury issuance (MSPD)
*     - Monetary policy shocks (BRW, Swanson, JK, NS, KSX)
*     - Financial indicators (div. yield, ZC yields, dollar share)
* 3. Merge outside asset and debt-only measures
* 4. Compute differences between holdings and portfolio exposures
* 5. Finalize tsset on `yq` and save

*---------------------------------------------------------------------*
* Notes:
* - Monetary units standardized to trillions of USD
* - FoF, FRED, and valuation calculations are versioned for reproducibility
* - Log transformations and returns computed in downstream regression scripts

***********************************************************************

// UK
do "$path/create_uk_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – United Kingdom       *
* Description:                                                        *
* This script builds a quarterly panel dataset on UK government bond *
* holdings by sector, combined with macro-financial indicators,      *
* monetary policy shocks, and asset price series.                    *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Processes UK gilt holdings by sector from ONS data
* - Merges:
*     > GDP and VIX from FRED
*     > Yield curve data, FTSE 100, and FX/CIP from Bloomberg
*     > Bank of England balance sheet in GBP
*     > Inflation (CPI) and debt-to-GDP from BIS dashboards
*     > UK zero-coupon yield curve (ZC rates)
*     > UK monetary policy shocks from Braun, Miranda-Agrippino, and Saha

*---------------------------------------------------------------------*
* Inputs (under $path/raw_data/):
* - Gilt_holdings_data_updated.xlsx:
*     > Sectoral holdings of gilts from ONS
* - DBSonline_BBG_UK_updated.xlsx:
*     > Bloomberg: yields, FTSE 100, CIP, FX rate
* - DBSonline_BoEassets_UK_updated.xlsx:
*     > BoE balance sheet assets in USD
* - DBSonline_MACRO_UK_updated.xlsx:
*     > Macro indicators (CPI, GDP)
* - series-260924.xls:
*     > Debt-to-GDP ratio (quarterly)
* - data_ZCYield.xlsx:
*     > Zero-coupon yields (sheet: "GB")
* - MP_shocks_other.xlsx:
*     > UK monetary policy shocks (BMAS event study)

* Pre-generated:
* - UK_FRED.dta:
*     > GDP, VIX, yields from FRED (downloaded on 2025-07-17)

*---------------------------------------------------------------------*
* Outputs (under $path/generated_data/):
* - UK_data_v202507.dta:
*     > Final merged quarterly dataset for UK government bond analysis

*---------------------------------------------------------------------*
* Workflow Summary:
* 1. Import gilt sectoral holdings and construct categories:
*     > MFI, ICPF, OFI, Central bank, HH, AllOther
* 2. Merge with macro data:
*     > FRED GDP & VIX, CPI inflation, debt-to-GDP, BoE assets (converted)
* 3. Merge financial market variables:
*     > FTSE returns, yield curve, CIP, ZC yields
* 4. Integrate monetary policy shocks from BMAS (Target, Path, QE)
* 5. Final time series set on `yq`, and save cleaned dataset

*---------------------------------------------------------------------*
* Notes:
* - Units standardized to trillions of GBP
* - Inflation is measured as log-difference of CPI
* - Monetary policy shock variables are quarter-summed event-study surprises
* - File paths accommodate multiple user machines (mac/windows)

***********************************************************************

// JP
do "$path/create_jp_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt  – Japan                *
* Description:                                                        *
* This script constructs a quarterly dataset on Japanese government   *
* bond (JGB) holdings by sector, merged with macroeconomic indicators,*
* interest rates, and monetary policy shock measures.                 *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Processes BoJ Flow of Funds data on sectoral JGB holdings
* - Constructs quarterly series of JGB shares and volumes by:
*     > Banks, ICPF, Households, Central Bank, ROW, Others
* - Merges:
*     > BoJ balance sheet and VIX from FRED
*     > Yield curve, CIP deviations, Nikkei returns from Bloomberg
*     > GDP, CPI, and debt-to-GDP from BIS Economic Dashboards
*     > Zero-coupon (ZC) JGB yield curve
*     > BoJ monetary policy shocks (Kubota & Shintani)

*---------------------------------------------------------------------*
* Inputs (under $path/raw_data/):
* - JGB_holdings_data_updated.xlsx:
*     > BoJ sectoral holdings data
* - DBSonline_BBG_JP_updated.xlsx:
*     > Bloomberg: JGB yields, Nikkei index, CIP, etc.
* - DBSonline_MACRO_JP_updated.xlsx:
*     > Macro indicators: GDP, CPI, debt-to-GDP
* - data_ZCYield.xlsx:
*     > Zero-coupon yield curve (sheet: "JP")
* - MP_shocks_other.xlsx:
*     > Quarterly monetary policy shocks from Kubota & Shintani

* Pre-generated:
* - JP_FRED.dta:
*     > BoJ assets, US yields, and VIX from FRED (as of 2025-07-17)

*---------------------------------------------------------------------*
* Outputs (under $path/generated_data/):
* - JP_data_v202507.dta:
*     > Final cleaned and merged dataset for Japanese bond analysis

*---------------------------------------------------------------------*
* Workflow Summary:
* 1. Import BoJ FoF holdings data, convert to volumes and share formats
* 2. Merge in macro-financial data:
*     > From FRED, BIS, Bloomberg, and ZC yield curve spreadsheets
* 3. Add monetary policy shock series:
*     > BoJ Target and Path shocks (Kubota-Shintani)
* 4. Compute derived variables (e.g., inflation, returns, CIP)
* 5. Time series set on `yq`, save as master dataset

*---------------------------------------------------------------------*
* Notes:
* - All holdings normalized to trillion JPY
* - Sector breakdowns used for motivation graphs and regression input
* - Data path accommodates both Mac and Windows systems
* - `JP_FRED.dta` includes US rates (THREEFY5, THREEFY8) for control vars

***********************************************************************

// EU
do "$path/create_eu_v202507.do"

***********************************************************************
* Project: The Demand for Government Debt – Euro Area            *
* Description:                                                        *
* This script constructs an annual dataset on euro area government    *
* bond holdings by sector, merged with macroeconomic indicators such  *
* as GDP and debt-to-GDP ratio.                                       *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Processes euro area government bond holdings by sector:
*     > Central Bank, MFI, Other FIs, Nonfinancial sector, ROW
* - Normalizes values to trillion EUR
* - Merges:
*     > GDP from FRED (annual nominal GDP)
* - Constructs:
*     > Debt-to-GDP ratio for the euro area

*---------------------------------------------------------------------*
* Inputs (under $path/raw_data/):
* - Euroarea_holdings_data_updated.xlsx:
*     > Sectoral holdings of government bonds (sheet: EA_holdings_short)

* Pre-generated:
* - EU_FRED.dta:
*     > Annual GDP series for euro area (EUNNGDP), downloaded from FRED
*       (retrieved on 2025-07-16)

*---------------------------------------------------------------------*
* Outputs (under $path/generated_data/):
* - EA_data_v202507.dta:
*     > Final merged dataset with normalized holdings and debt-to-GDP

*---------------------------------------------------------------------*
* Workflow Summary:
* 1. Import and clean EA holdings data (normalize units to trillions)
* 2. Merge in euro area GDP series
* 3. Compute debt-to-GDP ratio
* 4. Save annual time series as `EA_data_v202507.dta`

*---------------------------------------------------------------------*
* Notes:
* - Time variable is `year` (annual frequency)
* - Assumes euro area GDP = EUNNGDP * 4 (to harmonize with quarterly scale)
* - Path structure supports both macOS and Windows systems

***********************************************************************
***

// Section 2: Holders of government bonds

// US

do "$path/holders_us_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – United States             *
* Description:                                                        *
* This script constructs a quarterly dataset on U.S. Treasury         *
* holdings by sector, merged with macro-financial indicators and      *
* various monetary policy shock series. It supports regression-based  *
* analysis of sovereign debt demand and the changing composition of   *
* bondholders across policy regimes.                                  *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Loads and processes Flow of Funds data (FoF) from FRED
* - Merges with external datasets:
*     > Foreign UST holdings (official/private)
*     > Macro-financial variables (FRED, Treasury, etc.)
*     > Monetary policy shocks (BRW, Swanson, JK, NS, etc.)
*     > Treasury supply shocks and global asset prices
* - Constructs:
*     > Sector-level asset and debt holdings
*     > Total private sector UST holdings
*     > Measures of demand outside USTs by sector
*     > Returns, yields, and macro controls
* - Prepares data for:
*     > Regressions to estimate marginal demand for Treasuries
*     > Comparative charts and summary tables

*---------------------------------------------------------------------*
* Inputs (under $path/raw_data/):
* - Data.xlsx                           : Raw sectoral UST holdings
* - USTHoldings_20240924.xlsx          : Country-level foreign holdings
* - BRW2024-08.xlsx                     : Treasury auction shocks
* - Swanson_shocks.xlsx                : Forward guidance shocks
* - shocks_fed_jk_m_202409.xlsx        : Jarocinski-Karadi shocks
* - MPshocksAcosta.xlsx                : NS/Acosta shocks
* - IMFCOFER.xlsx                      : FX reserve currency shares
* - outside_assets_updated.xlsx        : Asset prices, SP500 dividend
* - data_ZCYield.xlsx                  : US zero-coupon rates
* - MSPD_SumSecty_20010131_20241031.xlsx : Treasury outstanding by maturity

* Preprocessed inputs:
* - US_FRED_macrofin.dta
* - US_FRED_FoF.dta
* - US_FRED_FoF_debt.dta

*---------------------------------------------------------------------*
* Outputs (under $path/generated_data/):
* - US_data_v202507.dta : Final merged and cleaned panel dataset

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `yq` (quarterly Stata date)
* - All monetary values standardized to trillions USD
* - Sector breakdowns: Banks, Mutual Funds, Pension Funds, Insurance, etc.
* - Includes constructed measures like "outside assets" and "debt-only holdings"
***********************************************************************

// UK
do "$path/holders_uk_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – United Kingdom       *
* Description:                                                        *
* This script loads and analyzes quarterly data on UK government      *
* bond holdings by sector. It generates time-series graphs of volume *
* and share composition, and runs regressions on the marginal         *
* response of sectoral holdings to changes in government debt.        *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Loads pre-constructed panel dataset of gilt holdings
* - Produces area graphs of sectoral holdings (volumes and shares)
* - Defines periods: pre-GFC, post-GFC, post-Covid, and QT
* - Computes sector-level changes in holdings relative to total debt
* - Runs regressions to estimate marginal buyers of UK government debt
* - Outputs LaTeX-formatted tables for regression results and averages

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/UK_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/UK_volumes.pdf
* - $path/graphs_paper/UK_shares.pdf
* - $path/tables_paper/UK_marginal_holders.tex
* - $path/tables_paper/UK_avg_by_time.tex

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `yq` (Stata quarterly format)
* - All amounts converted to trillions of GBP
* - Sector categories: Central Bank, MFIs, ICPF, OFI, HH, ROW, etc.
* - Shares are computed as % of total outstanding government debt
***********************************************************************


// JP 
do "$path/holders_jp_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – Japan               *
* Description:                                                        *
* This script loads and analyzes quarterly data on Japanese          *
* government bond (JGB) holdings by sector. It generates time-series *
* graphs of holding volumes and shares, and runs regressions to      *
* estimate marginal buyers of government debt across policy regimes. *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Loads pre-processed JGB sectoral holdings dataset
* - Produces stacked area charts for both volumes and shares
* - Defines policy periods: pre-QQE, QQE, and post-Covid
* - Computes sector-level changes in holdings relative to total debt
* - Runs regressions to identify marginal holders across periods
* - Outputs formatted LaTeX tables and graphs for use in documentation

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/JP_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/JP_volumes.pdf
* - $path/graphs_paper/JP_shares.pdf
* - $path/tables_paper/JP_marginal_holders.tex
* - $path/tables_paper/JP_avg_by_time.tex

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `yq` (Stata quarterly format)
* - Volumes expressed in trillions of yen
* - Share variables are in percentage of total debt
* - Sector categories include: Central Bank, Banks, ICPF, ROW, 
*   Public Pensions, Households (HH), and Others
***********************************************************************


// EU
do "$path/holders_eu_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – Euro Area           *
* Description:                                                        *
* This script loads and analyzes annual data on Euro Area sovereign  *
* bond holdings by sector. It generates stacked area charts for both *
* volumes and shares, and runs regressions to estimate marginal       *
* buyers across QE regimes.                                           *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Loads pre-processed Euro Area sectoral holdings dataset
* - Produces area graphs for debt holdings by sector (volume and share)
* - Defines QE policy regimes (pre-QE vs. post-QE)
* - Computes changes in holdings relative to total government debt
* - Runs regressions to identify marginal holders across time periods
* - Outputs formatted LaTeX tables and graphs for documentation

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/EA_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/EU_volumes.pdf
* - $path/graphs_paper/EU_shares.pdf
* - $path/tables_paper/EU_marginal_holders.tex
* - $path/tables_paper/EU_avg_by_time.tex

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `year` (annual)
* - Volumes expressed in trillions of euros
* - Share variables are in percentage of total debt
* - Sector categories include: Central Bank, ROW, MFIs, Other FIs,
*   and Non-financial institutions
***********************************************************************


// Section 3 & 4: US regressions and counterfactuals

// Transform variables for regressions

do "$path/transform_us_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script prepares and transforms quarterly U.S. macro-financial *
* and government bond holdings data to be used in regressions        *
* analyzing the demand for government debt. It merges multiple       *
* datasets, computes log changes and levels, adjusts for valuation   *
* effects, creates policy variables and instruments, and generates   *
* summary statistics and PCA components.                             *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Merges monetary policy, FX, and sectoral bond holdings data
* - Calculates logs and log changes of variables for use in regression
* - Adjusts holdings for valuation effects from changes in yields
* - Constructs alternative measures of monetary policy stance
* - Generates PCA-based instruments and standardized shock variables
* - Labels variables for presentation
* - Saves a final regression-ready dataset

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/mon_pol_shocks_v202507.dta
* - $path/generated_data/broad_nominal_FX_v202507.dta
* - $path/generated_data/US_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/generated_data/us_regression_cf_v202507.dta

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `yq` (quarterly)
* - Bond holdings are adjusted for valuation using zero-coupon duration
* - PCA components include BRW, JK, KSX, and NS measures of monetary policy
* - Variable naming conventions:
*     - `ln_*` = log level, `dln_*` = log difference
*     - `ir_*` = interest rate level, `dir_*` = interest rate change
*     - `diff_*`, `debtoa_diff_*` = adjusted log difference vs. outside asset
***********************************************************************

// Regressions for the main text & appendix for the US

do "$path/elasticity_us_v202507.do"
***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script runs regression analyses to study the demand for       *
* U.S. government debt across investor sectors and policy regimes.   *
* It evaluates the responsiveness of holdings to interest rates,     *
* using various monetary policy indicators and interaction terms.    *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Loads transformed U.S. dataset with valuation-adjusted holdings
* - Defines multiple sets of macro-financial control variables
* - Computes F-statistics for different monetary policy measures
* - Conducts regression analyses across sectors using PCA components
* - Includes robustness checks with varying yields, horizons, and
*   valuation adjustments
* - Tests for heterogeneous responses depending on QE (CB share ↓)
* - Produces TeX tables for baseline and appendix results

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/us_regression_cf_v202409.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/tables_paper/MaSc_US_pca_fs.tex
* - $path/tables_paper/MaSc_US_pca_fs_withcontrols.tex
* - $path/tables_paper/MaSc_US_pca_correlation.tex
* - $path/tables_paper/MaSc_US_pca_2sls.tex
* - $path/tables_paper/MaSc_US_pca_2sls_withcontrols.tex
* - $path/tables_paper/MaSc_US_negcb_int_2sls.tex
* - $path/tables_paper/MaSc_US_negcb_int_2sls_robgfcdum.tex
* - $path/tables_paper/MaSc_US_negcb_int_2sls_excqe1rob.tex
* - $path/tables_paper/MaSc_US_pca_2sls_outsideasset_debt[_wc].tex
* - $path/tables_paper/MaSc_US_pca_fs_outsideasset_wc.tex
* - $path/tables_paper/MaSc_US_pca_2sls_manycontrols.tex
* - $path/tables_paper/MaSc_US_pca_2sls_linear.tex
* - $path/tables_paper/MaSc_US_pca_2sls_jkmpbrwksxns.tex
* - $path/tables_paper/MaSc_US_pca_2sls_rc_inforesid.tex
* - $path/tables_paper/MaSc_US_pca_double_all_2sls.tex
* - $path/tables_paper/MaSc_US_pca_2sls_valadj[5|10].tex
* - $path/tables_paper/MaSc_US_pca_2sls_yield_valadj_[5y|10y].tex
* - $path/tables_paper/MaSc_US_pca_2sls_[5yyield|10yyield].tex
* - $path/tables_paper/MaSc_US_pca_2sls_lagcontrols.tex

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `yq` (quarterly, 2004q3–2024q2)
* - Estimations rely on different instrument sets (PCA, BRW, KSX, NS)
* - Valuation adjustments use 5Y, 8Y, and 10Y zero-coupon approximations
* - Sectoral variables include banks, PFs, ICs, IFs, SLG, etc.
* - Output tables are used directly in main text and appendix
***********************************************************************

// Counterfactuals for the US

do "$path/ts_counterfactuals_us_v202507.do" 
***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script simulates counterfactual scenarios to quantify the     *
* impact of different investor sectors on the price elasticity of    *
* demand for U.S. government debt. It estimates sectoral elasticities*
* and simulates yield impacts under various exclusion scenarios      *
* (e.g., without foreign official holders, banks, etc.),             *
* especially during QE and QT episodes.                              *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Computes sectoral elasticities using regression outputs
* - Merges holdings and residual supply data to construct weights
* - Calculates market-wide price elasticity of demand over time
* - Simulates counterfactual yield responses by excluding sectors
* - Quantifies yield impact of changes in Fed holdings across QE/QT
* - Produces yield and elasticity time series + bar charts

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/us_regression_cf_v202507.dta
* - $path/generated_data/US_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/timeseries_yield_counterfactuals.pdf
* - $path/graphs_paper/timeseries_prielas_counterfactuals.pdf
* - $path/graphs_paper/qe_qt_effect_diffelas.pdf
* - $path/graphs_paper/qe_qt_effect_fofpcounter.pdf
* - $path/graphs_paper/qe_qt_effect_allcounter.pdf
* - $path/graphs_paper/qe_qt_effect_somecounter.pdf
* - $path/graphs_paper/qe_qt_effect_allcounter_diff.pdf
* - $path/graphs_paper/share_among_select_sectors.pdf
* - $path/graphs_paper/pelas_among_select_sectors.pdf

*---------------------------------------------------------------------*
* Notes:
* - Time variable: `yq` (quarterly)
* - Baseline and counterfactual market elasticities are computed
*   using sectoral weights and valuation-adjusted responses
* - QE and QT impacts are interpreted through CB share changes
* - Graphs are used in both main text and appendix figures
***********************************************************************

// QE/QT counterfactuals

do "$path/qe_effect_counterfactual_v202507.do"
***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script visualizes the Federal Reserve's share of U.S.         *
* government debt over time, highlighting QE and QT periods. It      *
* calculates and plots estimated yield impacts based on observed     *
* changes in central bank holdings during these monetary regimes.    *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Computes central bank's share of Treasury holdings by quarter
* - Identifies QE1–QE4 and QT1–QT2 periods
* - Creates shaded time series chart of CB share and holdings
* - Estimates price impact of changes in CB share using elasticities

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/US_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/shr_cb.pdf — Time series with QE/QT shading
* - $path/graphs_paper/qe_qt_effect.pdf — Estimated yield impact by period
* - $path/graphs_paper/change_cb_share.pdf — Bar chart of share change

*---------------------------------------------------------------------*
* Notes:
* - Elasticity assumptions:
*     • 7.4 for QE periods
*     • 8.2 for QT periods
* - "Total_new" is used as denominator for all share calculations
***********************************************************************
// Appendix: Delving into investment funds

do "$path/us_inv_funds_v202507.do" 

***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script analyzes U.S. investment funds—Mutual Funds, ETFs, and *
* Closed-End Funds—as holders of government debt. It constructs and  *
* labels variables for regression-ready datasets, adjusts holdings   *
* for valuation changes, and estimates demand elasticities using     *
* PCA-identified monetary policy shocks. Also creates a time series  *
* graph and exports regression tables for the appendix.              *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Computes log-levels and log changes of investment fund holdings
* - Adjusts holdings for valuation effects using zero-coupon proxies
* - Creates publication-quality graph of fund holdings over time
* - Estimates elasticities of demand using PCA-based monetary shocks
* - Exports regression tables in LaTeX format

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/us_regression_cf_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/US_inv_funds.pdf
* - $path/tables_paper/US_inv_funds_pca.tex

*---------------------------------------------------------------------*
* Notes:
* - Sample covers 2004q3 to 2024q2
* - PCA factor `std_p1_jkbrwksx` proxies for monetary policy surprises
* - Regression controls: GDP, inflation, credit & volatility indicators
* - Elasticities for each fund type estimated separately
***********************************************************************


// Section 3.7: Japan and UK

// Japan
do "$path/elasticity_jp_v202507.do"

***********************************************************************
* Project: The Demand for Government Debt – Japan                    *
* Description:                                                       *
* This script constructs a dataset for demand elasticity analysis of *
* Japanese government bonds. It merges BOJ monetary policy shocks,   *
* macro variables, and sectoral holdings. It computes valuation-     *
* adjusted holdings, derives PCA-based instruments, and estimates    *
* elasticities across institutional sectors using 2SLS regressions.  *
* Outputs include F-stat tables, 2SLS results, and time series plots.*
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Merges BOJ policy shocks, macro data, and bond holdings
* - Constructs PCA instruments (BOJ KS, KSX) and log variables
* - Applies valuation adjustment using zero-coupon bond assumptions
* - Estimates first-stage F-stats and second-stage regressions
* - Computes and graphs time-varying market-level elasticities

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/mon_pol_shocks_v202507.dta
* - $path/generated_data/broad_nominal_FX_v202507.dta
* - $path/generated_data/JP_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/tables_paper/MaSc_JP_pca_fs.tex
* - $path/tables_paper/MaSc_JP_pca_2sls_ksx.tex
* - $path/tables_paper/MaSc_JP_pca_2sls_ks_ksx.tex
* - $path/graphs_paper/JP_yield_impact.pdf

*---------------------------------------------------------------------*
* Notes:
* - Elasticities are estimated using 2SLS with PCA-based shocks
* - Controls include GDP, inflation, VIX, Nikkei returns, etc.
* - Sectoral weights computed from actual holdings over time
* - Sample covers 2005q1 to 2024q2 (variable-specific)
***********************************************************************

// UK 
do "$path/elasticity_uk_v202507.do"

***********************************************************************
* Project: The Demand for Government Debt – United Kingdom           *
* Description:                                                       *
* This script constructs data for analyzing the demand for UK        *
* government debt using sectoral holdings and monetary policy        *
* shocks. It applies valuation adjustments, creates PCA instruments,*
* runs first-stage and second-stage regressions, and generates       *
* associated regression tables.                                      *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Merges monetary policy shocks, FX, and UK macro/holding data
* - Constructs log-levels and growth rates of holdings and variables
* - Adjusts holdings for valuation effects using zero-coupon bond 
*   price changes (5-, 8-, 10-year maturities)
* - Computes PCA instruments (BMAS, KSX)
* - Estimates sector-level elasticities using 2SLS
* - Outputs F-statistics and elasticity tables

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/mon_pol_shocks_v202507.dta
* - $path/generated_data/broad_nominal_FX_v202507.dta
* - $path/generated_data/UK_data_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/tables_paper/MaSc_GB_pca_fs.tex
* - $path/tables_paper/MaSc_GB_pca_2sls.tex

*---------------------------------------------------------------------*
* Notes:
* - Elasticities estimated using 2SLS with BMAS QE as preferred instrument
* - Controls include GDP, inflation, VIX, FTSE returns, etc.
* - Sector weights are not used dynamically in this version
***********************************************************************

/// Appendix: PCA - US 
do "$path/pca_v202507.do"

***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script explores principal components derived from U.S.        *
* monetary policy shocks, including visualizations, summary stats,   *
* and eigenvalue/eigenvector decomposition for interpretability.     *
***********************************************************************

*---------------------------------------------------------------------*
* Main Features:
* - Computes multiple sets of principal components (PCA) using:
*   • KSX (Ch3m, Ch2y, Ch10y), BRW
*   • JK MP, Swanson (FFR, LSAP, FG), CBI
* - Generates summary statistics and correlation table for PCAs
* - Constructs and exports:
*   • PCA time series plots
*   • PCA summary stats table
*   • Correlation matrix
*   • Eigenvalue decomposition table
*   • Eigenvector loadings

*---------------------------------------------------------------------*
* Inputs:
* - $path/generated_data/us_regression_cf_v202507.dta

*---------------------------------------------------------------------*
* Outputs:
* - $path/graphs_paper/US_pca_ts.pdf
* - $path/tables_paper/summary_pca.tex
* - $path/tables_paper/pca_correlation.tex
* - $path/tables_paper/pca_eigenvalue.tex
* - $path/tables_paper/pca_eigenvector.tex

*---------------------------------------------------------------------*
* Notes:
* - Eigenvalue table includes proportion and cumulative variance
* - Eigenvector loadings help interpret drivers of the components
* - Focus is on PCA with BRW, JK MP, and KSX for core analysis
***********************************************************************
log close
