***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script explores principal components derived from U.S.        *
* monetary policy shocks, including visualizations, summary stats,   *
* and eigenvalue/eigenvector decomposition for interpretability.     *
***********************************************************************
clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/



use "$path/generated_data/us_regression_cf_v202507.dta",clear


tsset yq

pca std_ir_Ch3m_Fed std_ir_Ch2y_Fed std_ir_Ch10y_Fed brw_monthly
*predict std_p1_brw_ksx std_p2_brw_ksx,score

pca std_ir_Ch3m_Fed std_ir_Ch2y_Fed std_ir_Ch10y_Fed brw_monthly std_FederalFundsRatefactor std_LSAPfactor std_ForwardGuidancefactor std_mp_median 
*predict std_p1_all_excinfo std_p2_all_excinfo,score

pca std_ir_Ch3m_Fed std_ir_Ch2y_Fed std_ir_Ch10y_Fed brw_monthly std_FederalFundsRatefactor std_LSAPfactor std_ForwardGuidancefactor std_mp_median  std_cbi_median
*predict std_p1_all std_p2_all,score

pca std_brw_monthly std_FederalFundsRatefactor std_LSAPfactor std_ForwardGuidancefactor std_mp_median 
*predict std_p1_early std_p2_early,score

pca brw_monthly mp_median 
*predict std_p1_brw_jkmp std_p2_brw_jkmp,score

	
////////////////////////////////////////////////////
////////////////////////////////////////////////////
// APPENDIX: DELVING INTO THE PRINCIPAL COMPONENTS 
////////////////////////////////////////////////////
//////////////////////////////////////////////////// 

** Time series 

bgshade yq, shaders(USREC) twoway(line std_p1_jkbrwksx yq if !missing(std_p1_jkbrwksx), lcolor(black) lpattern(solid) ///
|| line std_p1_jkbrwksxns yq if !missing(std_p1_jkbrwksxns), lcolor(black) lpattern(dash) xtitle("Quarter") graphre(color(white)) legend(pos(6))) 

 graph export "$path/graphs_paper/US_pca_ts.pdf",replace


 ** Summary statistics
 
sutex2 std_p1_jkbrwksx std_p1_jkbrwksxns, varlabels digits(2) saving("$path/tables_paper/summary_pca.tex") replace nocheck tabular 


** Correlation

corrtex std_p1_jkbrwksx std_p1_jkbrwksxns, file( "$path/tables_paper/pca_correlation") replace digits(2)

** Other info - Only report for PCA (JK MP, BRW, KSX)

label var std_brw_monthly "BRW"

label var std_mp_median "JK MP"

label var std_ir_Ch3m_Fed "KSX (3M)"
label var std_ir_Ch2y_Fed "KSX (2Y)"
label var std_ir_Ch10y_Fed "KSX (10Y)"

pca std_ir_Ch3m_Fed std_ir_Ch2y_Fed std_ir_Ch10y_Fed brw_monthly std_mp_median ,components(3)


matrix ev = e(Ev)'

matrix roweq ev = ""

matrix colnames ev = "Eigenvalue"


matrix d = ev - ( ev[2...,1] \ . )

matrix colnames d = "Difference"


matrix p = ev[1...,1] / e(trace)

matrix colnames p = "Proportion"


// I don't know a neat way of doing a cumulative sum
matrix c = J(e(trace),1,0)

matrix c[1,1] = p[1,1]

forvalues i=2/`e(trace)' {
matrix c[`i',1] = c[`=`i'-1',1] + p[`i',1]
       }

matrix colnames c = "Cumulative"

matrix t = ( ev , d , p , c )

 matrix list t


estadd matrix table = t



esttab, ///
   cells("table[Eigenvalue](t) table[Difference](t) table[Proportion](t fmt(4)) table[Cumulative](t fmt(4))") ///
    nogap noobs nonumber nomtitle


esttab using "$path/tables_paper/pca_eigenvalue", tex replace ///
    cells("table[Eigenvalue](t) table[Difference](t) table[Proportion](t fmt(4)) table[Cumulative](t fmt(4))") ///
    nogap noobs nonumber nomtitle 



esttab, ///
   cells("L[Comp1](t) L[Comp2](t) L[Comp3](t) Psi[Unexplained]") ///
    nogap noobs nonumber nomtitle

esttab using "$path/tables_paper/pca_eigenvector", tex replace ///
    cells("L[Comp1](t) L[Comp2](t) L[Comp3](t) Psi[Unexplained]") ///
     nogap noobs nonumber nomtitle label
