***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script visualizes the Federal Reserve's share of U.S.         *
* government debt over time, highlighting QE and QT periods. It      *
* calculates and plots estimated yield impacts based on observed     *
* changes in central bank holdings during these monetary regimes.    *
***********************************************************************


clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/

use "$path/generated_data/US_data_v202507.dta", clear
drop if HH==.

keep if inrange(yq,tq(2001q1),tq(2024q2))

	
foreach x of varlist HH row_fo row_fp Monetaryauthority MMFs SLG Banks IC PF IF Other {
gen shr_`x'=(`x'/Total_new)*100
}

/* This is the original start date, but start the period from one quarter before
gen qe1=inrange(yq,tq(2009q1),tq(2010q1))
gen qe2=inrange(yq,tq(2010q4),tq(2011q2))
gen qe3=inrange(yq,tq(2012q4),tq(2014q4))
gen qe4=inrange(yq,tq(2020q1),tq(2022q1))
gen qt1=inrange(yq,tq(2017q4),tq(2019q3))
gen qt2=inrange(yq,tq(2022q2),tq(2024q2))
*/

gen qe1=inrange(yq,tq(2009q1),tq(2010q1))
gen qe2=inrange(yq,tq(2010q3),tq(2011q2))
gen qe3=inrange(yq,tq(2012q4),tq(2014q4))
gen qe4=inrange(yq,tq(2019q4),tq(2021q4))
gen qt1=inrange(yq,tq(2017q4),tq(2019q3))
gen qt2=inrange(yq,tq(2022q1),tq(2024q2))

gen period="QE1" if qe1
replace period="QE2" if qe2
replace period="QE3" if qe3
replace period="QE4" if qe4
replace period="QT1" if qt1
replace period="QT2" if qt2
replace period="Other" if missing(period)

label var Monetaryauthority "CB UST holdings ($ trn), dashed line"
gen y = 30
* Create a graph with shaded areas and the time series
twoway ///
    (area y yq if qe1, color(gs12%30)) ///
    (area y yq if qe2, color(gs12%30)) ///
    (area y yq if qe3, color(gs12%30)) ///
    (area y yq if qe4, color(gs12%30)) ///
    (area y yq if qt1, color(gs8%30))  ///
    (area y yq if qt2, color(gs8%30)) ///
	 (line Monetaryauthority yq, lwidth(medium) lcolor(black) yaxis(2) lpattern(dash)) ///
    (line shr_Monetaryauthority yq, lwidth(medium) lcolor(black)) if yq>tq(2008q4), ///
      ylabel(, angle(horizontal)) ///
      xtitle("Quarter") ytitle("Share of the central bank in government debt (%)") legend(off) text(29 `=tq(2009q3)' "QE1")  text(29 `=tq(2011q1)' "QE2") text(29 `=tq(2013q4)' "QE3") text(29 `=tq(2020q4)' "QE4") text(29 `=tq(2018q3)' "QT1") text(29 `=tq(2023q2)' "QT2") scheme(stmono1) 
	 graph export "$path/graphs_paper/shr_cb.pdf",replace

preserve
bys period: egen min_date=min(yq)
bys period: egen max_date=max(yq)
sort yq
format min_date %tq
format max_date %tq
drop if period =="Other"
keep if yq==min_date | yq==max_date
sort period yq
bys period: gen diff_cb=shr_Monetaryauthority[_n]-shr_Monetaryauthority[_n-1]
*gen elasticity=7.4 if substr(period,1,2)=="QE"
*replace elasticity = 8.2 if substr(period,1,2)=="QT"
*drop if diff_cb==.
*gen price_impact=-diff_cb*elasticity
*graph bar price_impact,over(period) ytitle("Impact on yields (bps)") scheme(stmono1) 
*graph export "$path/graphs_paper/qe_qt_effect.pdf",replace
graph bar diff_cb,over(period)
graph export "$path/graphs_paper/change_cb_share.pdf",replace
restore

