***********************************************************************
* Project: The Demand for Government Debt – United States            *
* Description:                                                       *
* This script prepares and transforms quarterly U.S. macro-financial *
* and government bond holdings data to be used in regressions        *
* analyzing the demand for government debt. It merges multiple       *
* datasets, computes log changes and levels, adjusts for valuation   *
* effects, creates policy variables and instruments, and generates   *
* summary statistics and PCA components.                             *
***********************************************************************

clear all
set more off

/* Uncomment if running this file separately. 
* Set path

foreach path in "Add your directory here" "/Users/egemeneren/Dropbox/QT/Data/MaSc_RR_202507" "C:\Users\eg003762\BIS Dropbox\Egemen Eren\QT\Data\MaSc_RR_202507"  {
	capture cd "`path'"
	if _rc == 0 macro def path `path'
} 
*/

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

// Clean and transform variables for elasticity regressions
use "$path/generated_data/mon_pol_shocks_v202507.dta",clear
merge 1:1 yq using "$path/generated_data/broad_nominal_FX_v202507.dta",nogen
merge 1:1 yq using "$path/generated_data/US_data_v202507.dta",nogen

tsset yq

//Generate logs and log changes

// Holding data
foreach x of varlist HH ROW Monetaryauthority MMFs SLG Banks ICPF IF Other PF IC row_* HOLD* Total_new all_pri fv_all_pri {
gen dln_`x'=ln(`x')-ln(l.`x')
gen ln_`x'=ln(`x')
}


// Valuation changes - assuming everyone holds X-year zero coupon bonds.

gen val_ch10_pct=-(d.THREEFY10/100)*10
gen val_ch8_pct=-(d.THREEFY8/100)*8
gen val_ch5_pct=-(d.THREEFY5/100)*5


foreach x of varlist HH ROW Monetaryauthority MMFs SLG Banks ICPF IF Other PF IC row_* HOLD* Total_new all_pri fv_all_pri {
	foreach i in 5 8 10 {
gen val_ch`i'_`x'= l.`x'*val_ch`i'_pct
gen `x'_exval`i'=`x'-val_ch`i'_`x'
gen ln_`x'_exval`i'=ln(`x'_exval`i')
gen dln_`x'_exval`i'=ln(`x'_exval`i')-ln(l.`x'_exval`i')
}
}
///////

// Fred variables
foreach y of varlist GDP VIXCLS USACPICORMINMEI WALCL TREAST SOMA_fv old_UST_fv UST_fv NBUS gdp_per_capita NFCI STLFSI4 {
gen dln_`y'=ln(`y')-ln(l.`y')
gen ln_`y'=ln(`y')
}

// Interest rates
*foreach t of varlist THREE* DGS* inf_exc_fe stock_ret usd_ret ffr spread_ig spread_aaa sp_div_yield german_5y_zc german_10y_zc {
	foreach t of varlist THREE* DGS* inf_exc_fe usd_ret ffr spread_ig spread_aaa sp_div_yield german_5y_zc german_10y_zc {

gen dir_`t'=`t'/100-l.`t'/100
gen ir_`t'=`t'/100
gen dln_`t'=ln(1+`t'/100)-ln(1+l.`t'/100)
gen ln_`t'=ln(1+`t'/100)

}

// Mon pol shocks
foreach t of varlist Ch* {
gen dln_`t'=ln(1+`t')-ln(1+l.`t')
gen ln_`t'=ln(1+`t')
gen dir_`t'=`t'-l.`t'
gen ir_`t'=`t'
}

//// CHANGE HAS BEEN MADE HERE - CAREFUL!
// Outside asset
foreach t of varlist *exUST *debtoa {
cap gen dln_`t'=ln(`t')-ln(l.`t')
cap gen ln_`t'=ln(`t')
}

foreach t of varlist PF IF HH Banks SLG IC {
	
gen diff_`t'=ln_`t'_exval8-ln_`t'_exUST
label var diff_`t' "log(`t')-log(OA\$ _{`t'}$)"
}

foreach t of varlist PF IF  Banks SLG IC {
	
gen debtoa_diff_`t'=ln_`t'_exval8-ln_`t'_debtoa
label var debtoa_diff_`t' "log(`t')-log(DebtOA\$ _{`t'}$)"
}

gen alt_post_gfc=yq>=tq(2009q1)
gen yq_sq=yq^2


// Alternative instruments
egen avg_mon_pol_3m10y=rowmean(ir_Ch3m_Fed ir_Ch10y_Fed)
egen avg_mon_pol_3m2y10y=rowmean(ir_Ch3m_Fed ir_Ch2y_Fed ir_Ch10y_Fed)

/// Run this before regressions if creating tables. 
/// Label variables 

label var ln_Total_new "log(Total UST)"
label var ln_WALCL "log(CB BS)"
*label var ir_stock_ret "stock mkt return"
label var ir_usd_ret "broad usd return"
label var ln_GDP "log GDP"
label var ln_VIXCLS "log VIX"
label var ir_inf_exc_fe "inflation"
label var yq "trend"
label var yq_sq "trend squared"

label var ir_spread_ig "ICE BofA OAS IG"
label var ir_spread_aaa "ICE BofA OAS AAA"
label var ir_sp_div_yield "SP500 dividend yield"
label var ir_german_5y_zc "German 5Y (ZC)"
label var ir_german_10y_zc "German 10Y (ZC)"


label var ln_Banks "log(Banks)"
label var ln_PF "log(PF)"
label var ln_row_fp "log(ROW Pri)"
label var ln_row_fo "log(ROW Off)"
label var ln_IF "log(IF)"
label var ln_SLG "log(SLG)"
label var ln_HH "log(HH)"
label var ln_IC "log(IC)"
label var ln_Other "log(Other)"
label var ln_all_pri "log(All Non-CB)"
label var ln_MMFs "log(MMF)"
label var ln_fv_all_pri "log(All Non-CB (FV))"


label var ln_Banks_exval10 "log(Banks)"
label var ln_PF_exval10 "log(PF)"
label var ln_row_fp_exval10 "log(ROW Pri)"
label var ln_row_fo_exval10 "log(ROW Off)"
label var ln_IF_exval10 "log(IF)"
label var ln_SLG_exval10 "log(SLG)"
label var ln_HH_exval10 "log(HH)"
label var ln_IC_exval10 "log(IC)"
label var ln_Other_exval10 "log(Other)"
label var ln_all_pri_exval10 "log(All Non-CB)"
label var ln_MMFs_exval10 "log(MMF)"

label var ln_Banks_exval8 "log(Banks)"
label var ln_PF_exval8 "log(PF)"
label var ln_row_fp_exval8 "log(ROW Pri)"
label var ln_row_fo_exval8 "log(ROW Off)"
label var ln_IF_exval8 "log(IF)"
label var ln_SLG_exval8 "log(SLG)"
label var ln_HH_exval8 "log(HH)"
label var ln_IC_exval8 "log(IC)"
label var ln_Other_exval8 "log(Other)"
label var ln_all_pri_exval8 "log(All Non-CB)"
label var ln_MMFs_exval8 "log(MMF)"

label var ln_Banks_exval5 "log(Banks)"
label var ln_PF_exval5 "log(PF)"
label var ln_row_fp_exval5 "log(ROW Pri)"
label var ln_row_fo_exval5 "log(ROW Off)"
label var ln_IF_exval5 "log(IF)"
label var ln_SLG_exval5 "log(SLG)"
label var ln_HH_exval5 "log(HH)"
label var ln_IC_exval5 "log(IC)"
label var ln_Other_exval5 "log(Other)"
label var ln_all_pri_exval5 "log(All Non-CB)"
label var ln_MMFs_exval5 "log(MMF)"

label var ir_DGS1 "1Y Yield"
label var ir_DGS2  "2Y Yield"
label var ir_DGS5  "5Y Yield"
label var ir_DGS10  "10Y Yield"
label var ir_DGS3MO  "3M Yield"

label var ir_THREEFY10 "10Y Yield (ZC)"
label var ir_THREEFY8 "8Y Yield (ZC)"
label var ir_THREEFY5 "5Y Yield (ZC)"

label var ir_Ch3m_Fed "KSX (3M)"
label var ir_Ch2y_Fed "KSX (2Y)"
label var ir_Ch10y_Fed "KSX (10Y)"


// Principal components
tsset yq

pca brw_monthly mp_median ir_Ch3m_Fed ir_Ch2y_Fed ir_Ch10y_Fed
predict p1_jkbrwksx p2_jkbrwksx, score 

pca brw_monthly mp_median ir_Ch3m_Fed ir_Ch2y_Fed ir_Ch10y_Fed ns
predict p1_jkbrwksxns p2_jkbrwksxns, score 

label var brw_monthly "BRW"

label var FederalFundsRatefactor "Swanson FFR"
label var ForwardGuidancefactor "Swanson FG"
label var LSAPfactor "Swanson LSAP"

label var mp_median "JK MP"
label var cbi_median "JK CBI"

label var ns "Nakamura-Steinsson"

label var p1_jkbrwksx "PCA 1 (JK MP, BRW, KSX)"
label var p2_jkbrwksx "PCA 2 (JK MP, BRW, KSX)"

label var p1_jkbrwksxns "PCA 1 (JK MP, BRW, KSX, NS)"
label var p2_jkbrwksxns "PCA 2 (JK MP, BRW, KSX, NS)"


** Summary statistics 

*foreach mps in "mp_median" "cbi_median" "FederalFundsRatefactor" "ForwardGuidancefactor" "LSAPfactor" "brw_monthly" "ir_Ch3m_Fed" "ir_Ch2y_Fed" "ir_Ch10y_Fed" "p1_early" "p2_early" "p1_all" "p2_all" "p1_all_excinfo" "p2_all_excinfo" "p1_brw_ksx" "p2_brw_ksx" "p1_brw_jkmp" "p2_brw_jkmp" {

foreach mps in "mp_median" "cbi_median" "FederalFundsRatefactor" "ForwardGuidancefactor" "LSAPfactor" "brw_monthly" "ns" "ir_Ch3m_Fed" "ir_Ch2y_Fed" "ir_Ch10y_Fed" "p1_jkbrwksx" "p2_jkbrwksx" "p1_jkbrwksxns" "p2_jkbrwksxns"  {

egen std_`mps'=std(`mps')

}

label var std_brw_monthly "BRW"
label var std_FederalFundsRatefactor "Swanson FFR"
label var std_ForwardGuidancefactor "Swanson FG"
label var std_LSAPfactor "Swanson LSAP"

label var std_ns "Nakamura-Steinsson"

label var std_mp_median "JK MP"
label var std_cbi_median "JK CBI"

label var std_ir_Ch3m_Fed "KSX (3M)"
label var std_ir_Ch2y_Fed "KSX (2Y)"
label var std_ir_Ch10y_Fed "KSX (10Y)"

label var std_p1_jkbrwksx "PCA 1 (JK MP, BRW, KSX)"
label var std_p2_jkbrwksx "PCA 2 (JK MP, BRW, KSX)"

label var std_p1_jkbrwksxns "PCA 1 (JK MP, BRW, KSX, NS)"
label var std_p2_jkbrwksxns "PCA 2 (JK MP, BRW, KSX, NS)"


save "$path/generated_data/us_regression_cf_v202507.dta",replace
